/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.test.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.advancement.predicate.ExposurePredicate;
import io.github.mortuusars.exposure.test.framework.ITestClass;
import io.github.mortuusars.exposure.test.framework.Test;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;

public class ExposurePredicateTests
implements ITestClass {
    @Override
    public List<Test> collect() {
        return List.of(new Test("ExposurePredicate_DeserializesProperly", this::deserializesProperly));
    }

    private void deserializesProperly(ServerPlayer serverPlayer) {
        String json = "{\n  \"owner\": true,\n  \"shutter_speed_ms\": {\n    \"min\": 50\n  },\n  \"entities_count\": {\n    \"max\": 5\n  }\n}\n";
        JsonObject jsonObj = GsonHelper.m_13864_((String)json).getAsJsonObject();
        ExposurePredicate exposurePredicate = ExposurePredicate.fromJson((JsonElement)jsonObj);
        CompoundTag frame = new CompoundTag();
        frame.m_128362_("PhotographerId", serverPlayer.m_20148_());
        frame.m_128350_("ShutterSpeedMS", 100.0f);
        ListTag entities = new ListTag();
        entities.add((Object)new CompoundTag());
        entities.add((Object)new CompoundTag());
        frame.m_128365_("Entities", (Tag)entities);
        this.assertThat(exposurePredicate.matches(serverPlayer, frame), "Deserialized predicate does not match frame: " + frame);
    }
}

